<?php
 
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\ProductPurchase;
use App\Models\Product_Sale;
use App\Models\ProductReturn;
use App\Models\ProductAdjustment;
use Carbon\Carbon;

class ReportsController extends Controller
{
    public function productStockReport(Request $request)
    {
        // Date range
        
  $start = $request->input('start_date') 
            ? Carbon::parse($request->input('start_date'))->startOfDay() 
            : Carbon::today()->startOfDay();
        $end = $request->input('end_date') 
            ? Carbon::parse($request->input('end_date'))->endOfDay() 
            :Carbon::today()->endOfDay();

        $products = Product::all();

        $report = [];

        foreach ($products as $product) {
            // Opening balance: purchases - sales (sale_status=5) + returns + adjustments before start
            $opening_purchases = ProductPurchase::where('product_id', $product->id)
                ->whereHas('purchase', function($q) use ($start) {
                    $q->where('created_at', '<', $start);
                })->sum('qty');

            // Use product_takens for opening sales
            $opening_sales = \DB::table('product_takens')
                ->join('product_sales', 'product_takens.product_sale_id', '=', 'product_sales.id')
                ->where('product_sales.product_id', $product->id)
                ->where('product_takens.created_at', '<', $start)
                ->sum('product_takens.qty');

            $opening_returns = ProductReturn::where('product_id', $product->id)
                ->where('created_at', '<', $start)
                ->sum('qty');

            // Opening adjustments
            $opening_adjust_add = ProductAdjustment::where('product_id', $product->id)
                ->where('action', '+')
                ->where('created_at', '<', $start)
                ->sum('qty');
            $opening_adjust_sub = ProductAdjustment::where('product_id', $product->id)
                ->where('action', '-')
                ->where('created_at', '<', $start)
                ->sum('qty');

            $opening_balance = $opening_purchases - $opening_sales + $opening_returns + $opening_adjust_add - $opening_adjust_sub;

            // Purchases in period
            $period_purchases = ProductPurchase::where('product_id', $product->id)
                ->whereHas('purchase', function($q) use ($start, $end) {
                    $q->whereBetween('created_at', [$start, $end]);
                })->sum('qty');

            // Use product_takens for period sales
            $period_sales = \DB::table('product_takens')
                ->join('product_sales', 'product_takens.product_sale_id', '=', 'product_sales.id')
                ->where('product_sales.product_id', $product->id)
                ->whereBetween('product_takens.created_at', [$start, $end])
                ->sum('product_takens.qty');

            // Returns in period
            $period_returns = ProductReturn::where('product_id', $product->id)
                ->whereBetween('created_at', [$start, $end])
                ->sum('qty');

            // Period adjustments
            $period_adjust_add = ProductAdjustment::where('product_id', $product->id)
                ->where('action', '+')
                ->whereBetween('created_at', [$start, $end])
                ->sum('qty');
            $period_adjust_sub = ProductAdjustment::where('product_id', $product->id)
                ->where('action', '-')
                ->whereBetween('created_at', [$start, $end])
                ->sum('qty');

            // Ending balance
            $ending_balance = $opening_balance + $period_purchases - $period_sales + $period_returns + $period_adjust_add - $period_adjust_sub;

         $report[] = [
    'product' => $product,
    'opening' => $opening_balance,
    'purchases' => $period_purchases,
    'sales' => $period_sales,
    'ending' => $ending_balance,
    'adjustment' => $period_adjust_add - $period_adjust_sub, // single adjustment column
];
        }

        return view('backend.reports.product_stock', compact('report', 'start', 'end'));
    }
}