@extends('backend.layout.main')

@section('content')
<div class="container-fluid">
    <h3 class="text-center mt-3 mb-4">Product Stock Report</h3>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <strong>Start Date:</strong> {{ \Carbon\Carbon::parse($start)->format('Y-m-d') }}<br>
            <strong>End Date:</strong> {{ \Carbon\Carbon::parse($end)->format('Y-m-d') }}
        </div>
        <button class="btn btn-secondary" onclick="window.print()">
            <i class="fa fa-print"></i> Print
        </button>
    </div>
    <form method="get" class="mb-4 d-print-none">
        <div class="row">
            <div class="col-md-3">
                <label>Start Date</label>
                <input type="date" name="start_date" value="{{ \Carbon\Carbon::parse($start)->format('Y-m-d') }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>End Date</label>
                <input type="date" name="end_date" value="{{ \Carbon\Carbon::parse($end)->format('Y-m-d') }}" class="form-control">
            </div>
            <div class="col-md-2 align-self-end">
                <button class="btn btn-primary" type="submit">Filter</button>
            </div>
        </div>
    </form>
    <div class="table-responsive">
        <table class="table table-bordered" id="stock-report-table">
            <thead>
                <tr> 
                    <th>#</th>
                    <th>Product</th>
                    <th>Opening Balance</th>
                    <th>Purchases</th>
                    <th>Adjustments</th>
                    <th>Taken Sales</th>
                    <th>Ending Balance</th>
                </tr>
            </thead>
            <tbody>
                @foreach($report as $i => $row)
                <tr>
                    <td>{{ $i+1 }}</td>
                    <td>{{ $row['product']->name }} </td>
                    <td>{{ $row['opening'] }}</td>
                    <td>{{ $row['purchases'] }}</td>
                    <td>{{ $row['adjustment'] }}</td>
                    <td>{{ $row['sales'] }}</td>
                    <td>{{ $row['ending'] }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection