 @extends('backend.layout.main')

@section('content')
<div class="container mt-4">
    <h3>Loading History for Product: <b>{{ $productSale->product->name ?? '' }}</b> (Sale Ref: {{ $productSale->sale->reference_no ?? '' }})</h3>
    <a href="{{ url()->previous() }}" class="btn btn-secondary mb-3">Back</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Sale Reference</th>
                <th>Quantity Taken</th>
                <th>Date/Time</th>
            </tr>
        </thead>
        <tbody>
            @forelse($takens as $i => $taken)
                <tr>
                    <td>{{ $i+1 }}</td>
                    <td>{{ $taken->sale_reference }}</td>
                    <td>{{ $taken->qty }}</td>
                    <td>{{ \Carbon\Carbon::parse($taken->created_at)->format('Y-m-d H:i:s') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="text-center">No loading history found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection