

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <h3 class="text-center mt-3 mb-4">Product Stock Report</h3>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <strong>Start Date:</strong> <?php echo e(\Carbon\Carbon::parse($start)->format('Y-m-d')); ?><br>
            <strong>End Date:</strong> <?php echo e(\Carbon\Carbon::parse($end)->format('Y-m-d')); ?>

        </div>
        <button class="btn btn-secondary" onclick="window.print()">
            <i class="fa fa-print"></i> Print
        </button>
    </div>
    <form method="get" class="mb-4 d-print-none">
        <div class="row">
            <div class="col-md-3">
                <label>Start Date</label>
                <input type="date" name="start_date" value="<?php echo e(\Carbon\Carbon::parse($start)->format('Y-m-d')); ?>" class="form-control">
            </div>
            <div class="col-md-3">
                <label>End Date</label>
                <input type="date" name="end_date" value="<?php echo e(\Carbon\Carbon::parse($end)->format('Y-m-d')); ?>" class="form-control">
            </div>
            <div class="col-md-2 align-self-end">
                <button class="btn btn-primary" type="submit">Filter</button>
            </div>
        </div>
    </form>
    <div class="table-responsive">
        <table class="table table-bordered" id="stock-report-table">
            <thead>
                <tr> 
                    <th>#</th>
                    <th>Product</th>
                    <th>Opening Balance</th>
                    <th>Purchases</th>
                    <th>Adjustments</th>
                    <th>Taken Sales</th>
                    <th>Ending Balance</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($i+1); ?></td>
                    <td><?php echo e($row['product']->name); ?> </td>
                    <td><?php echo e($row['opening']); ?></td>
                    <td><?php echo e($row['purchases']); ?></td>
                    <td><?php echo e($row['adjustment']); ?></td>
                    <td><?php echo e($row['sales']); ?></td>
                    <td><?php echo e($row['ending']); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/volcouct/volkanbricks.online/resources/views/backend/reports/product_stock.blade.php ENDPATH**/ ?>