
<?php $__env->startSection('content'); ?>
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Finalize Challan</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>The field labels marked with * are required input fields.</small></p>
                        <form action="<?php echo e(route('challan.update', $challan->id)); ?>" method="post">
                        <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><strong>Reference No</strong> </label>
                                        <p><?php echo e('DC-'.$challan->reference_no); ?></p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><strong>Date</strong> </label>
                                        <p><?php echo e(date(config('date_format'), strtotime($challan->created_at))); ?></p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><strong>Rider/Courier</strong> </label>
                                        <p><?php echo e($challan->courier->name.' ['.$challan->courier->phone_number.']'); ?></p>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <h5>Order List</h5>
                                    <?php
                                        $packing_slip_list = explode(",", $challan->packing_slip_list);
                                        $amount_list = explode(",", $challan->amount_list);
                                        $amount_list = explode(",", $challan->amount_list);
                                        $dcharge = $challan->courier->dcharge ?? 0; // Fetch dcharge from courier
                                        $pcharge = $challan->courier->pcharge ?? 0; // Fetch dcharge from courier
                                    ?>
                                    <div class="table-responsive">
                                        <table class="table table-hover" id="flat-type-table">
                                            <thead>
                                                <tr>
                                                    <th>PS Reference</th>
                                                    <th>Order Reference</th>
                                                    <th>Amount</th>
                                                    <th>Total Qty</th>
                                                    <th>Porter Charge</th>
                                                    <th>Delivery Driver Charge</th>
                                                    <th>Cheque</th>
                                                    <th>Other Payment</th>
                                                    <th class="d-none">Return</th>
                                                    <th class="d-none">Return Note</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $packing_slip_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$packing_slip_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $packing_slip = \App\Models\PackingSlip::with('sale')->find($packing_slip_id);
                                                    // Use the already registered quantity
                                                    $total_qty = $packing_slip->quantity;
                                                    $driver_charge = $dcharge * $total_qty;
                                                    $porter_charge = $pcharge * $total_qty;
                                                ?>
                                                <tr>
                                                    <td><?php echo e($packing_slip->reference_no); ?></td>
                                                    <td><?php echo e($packing_slip->sale->reference_no); ?></td>
                                                    <td><?php echo e($amount_list[$key]); ?></td>
                                                    <td><?php echo e($total_qty); ?></td>
                                                    <td><input type="number" readonly name="cash_list[]" class="form-control" value=<?php echo e($porter_charge); ?>></td> 
                                                    <td>
                                                        <input type="number" name="delivery_charge_list[]" class="form-control" value="<?php echo e($driver_charge); ?>" readonly>
                                                    </td>
                                                    <td><input readonly type="number" name="cheque_list[]" class="form-control"></td>
                                                    <td><input readonly type="number" name="online_payment_list[]" class="form-control"></td>
                                                    <td class="d-none"><input type="checkbox" name="refund_list[]" value="<?php echo e($packing_slip_id); ?>"></td>
                                                    <td class="d-none"><input type="textbox" class="form-control" name="return_note[]"></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group mt-4">
                                        <input type="submit" value="Submit" class="btn btn-primary">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $("ul#sale").siblings('a').attr('aria-expanded','true');
        $("ul#sale").addClass("show");
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/volcouct/public_html/resources/views/backend/challan/finalize.blade.php ENDPATH**/ ?>