
<?php $__env->startSection('content'); ?>
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Create Challan</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>The field labels marked with * are required input fields.</small></p>
                        <form action="<?php echo e(route('challan.store')); ?>" method="post" id="challan-form">
                        <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><strong>Date</strong> </label>
                                        <input type="text" name="created_at" class="form-control date" autocomplete="false">
                                    </div>
                                </div>

                                <div class="col-md-4 courier-section">
                                    <div class="form-group">
                                        <label><strong>Courier *</strong></label>
                                        <select name="courier_id" required id="courier-id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select courier...">
                                            <?php $__currentLoopData = $courier_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($courier->id); ?>"><?php echo e($courier->name.' ['.$courier->phone_number.']'); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-9 mt-3">
                                    <h5>Order List</h5>
                                    <div class="table-responsive">
                                        <table class="table table-hover" id="flat-type-table">
                                            <thead>
                                                <tr>
                                                    <th>sale Reference</th>
                                                    <th>Packing Slip Reference</th>
                                                    <th>Amount</th>
                                                    <th>Delete</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            	<?php $__currentLoopData = $packing_slip_all; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $packing_slip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($packing_slip->sale->reference_no); ?></td>
                                                    <td><input type="hidden" name="packing_slip_list[]" value="<?php echo e($packing_slip->id); ?>">P<?php echo e($packing_slip->reference_no); ?></td>
                                                    <td><input type="number" name="amount_list[]" class="form-control" value="<?php echo e($packing_slip->amount); ?>" readonly></td>
                                                    <td><button class="btn btn-danger btn-sm btnDel" type="button">X</button></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group mt-4">
                                        <input type="submit" value="Submit" class="btn btn-primary submit-btn">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $("ul#sale").siblings('a').attr('aria-expanded','true');
        $("ul#sale").addClass("show");

        $(document).on('submit', '#challan-form', function(e) {
            $(".submit-btn").prop("disabled", true);
        });

        $("#add-more").on("click", function() {
            var newRow = $("<tr>");
            var cols = '';
            cols += '<td><input type="text" name="sale_no[]" class="form-control"></td>';
            cols += '<td><input type="number" name="amount[]" class="form-control"></td>';
            cols += '<td><button class="btn btn-danger btn-sm btnDel" type="button">X</button></td>';

            newRow.append(cols);
            $("table#flat-type-table tbody").append(newRow);
        });

        //Delete flat type
        $("table#flat-type-table tbody").on("click", ".btnDel", function(event) {
            $(this).closest("tr").remove();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/volcouct/public_html/resources/views/backend/challan/create.blade.php ENDPATH**/ ?>